/*
 * Decompiled with CFR 0.152.
 */
package dev.zy.sensorboard.gui;

import com.fazecast.jSerialComm.SerialPort;
import com.formdev.flatlaf.FlatDarkLaf;
import com.formdev.flatlaf.extras.FlatSVGIcon;
import dev.zy.sensorboard.data.Record;
import dev.zy.sensorboard.gui.About;
import dev.zy.sensorboard.processor.HTTPProcessor;
import dev.zy.sensorboard.processor.PeriodicRecorder;
import dev.zy.sensorboard.processor.Processor;
import dev.zy.sensorboard.processor.SerialMonitor;
import dev.zy.sensorboard.processor.SerialProcessor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Taskbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;

public class Client
extends JFrame {
    SerialPort[] comPorts;
    SerialMonitor com;
    SerialProcessor comProc;
    HTTPProcessor httpProc;
    Processor proc;
    PeriodicRecorder periCoder;
    boolean serialMode;
    ImageIcon appIcon = new ImageIcon(this.getClass().getResource("/dev/zy/sensorboard/icon/icon.png"));
    private ButtonGroup buttonGroup1;
    private JLabel icon;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JComboBox<String> jComboBox1;
    private JComboBox<String> jComboBox2;
    private JComboBox<String> jComboBox3;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JPopupMenu.Separator jSeparator5;
    private JSlider jSlider1;
    private JSlider jSlider2;
    private JSpinner jSpinner1;
    private JSplitPane jSplitPane1;
    private JTable jTable2;
    private JTextField jTextField1;
    private JToggleButton jToggleButton1;
    private JToggleButton jToggleButton2;

    public Client() {
        this.initComponents();
        Taskbar taskbar = Taskbar.getTaskbar();
        try {
            taskbar.setIconImage(this.appIcon.getImage());
        }
        catch (SecurityException | UnsupportedOperationException runtimeException) {
            // empty catch block
        }
        this.com = new SerialMonitor();
        this.comProc = new SerialProcessor(this.com);
        this.comPorts = SerialPort.getCommPorts();
        this.proc = this.comProc;
        if (this.comPorts.length >= 1) {
            this.com.setCom(this.comPorts[0]);
        }
        this.httpProc = new HTTPProcessor("192.168.4.1");
        this.jToggleButton1ActionPerformed(null);
        this.enableFunc(false);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jToggleButton1 = new JToggleButton();
        this.jToggleButton2 = new JToggleButton();
        this.jLabel2 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jSlider1 = new JSlider();
        this.jSlider2 = new JSlider();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.jLabel8 = new JLabel();
        this.jButton1 = new JButton();
        this.jLabel9 = new JLabel();
        this.jComboBox2 = new JComboBox();
        this.jSeparator3 = new JSeparator();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jButton2 = new JButton();
        this.jSeparator4 = new JSeparator();
        this.jLabel12 = new JLabel();
        this.jComboBox3 = new JComboBox();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jButton4 = new JButton();
        this.icon = new JLabel();
        this.jSpinner1 = new JSpinner();
        this.jPanel2 = new JPanel();
        this.jLabel15 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jTable2 = new JTable();
        this.jButton3 = new JButton();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jSeparator5 = new JPopupMenu.Separator();
        this.jMenuItem3 = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.jMenuItem2 = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("Sensor Borad Demo Client");
        this.setIconImage(this.appIcon.getImage());
        this.setLocationByPlatform(true);
        this.setMinimumSize(new Dimension(843, 500));
        this.setName("clientFrame");
        this.jSplitPane1.setDividerLocation(440);
        this.jPanel1.setMinimumSize(new Dimension(440, 476));
        this.jLabel1.setText("Communication Type");
        this.buttonGroup1.add(this.jToggleButton1);
        this.jToggleButton1.setSelected(true);
        this.jToggleButton1.setText("COM");
        this.jToggleButton1.putClientProperty("JButton.buttonType", "roundRect");
        this.jToggleButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Client.this.jToggleButton1ActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jToggleButton2);
        this.jToggleButton2.setText("WiFi");
        this.jToggleButton2.setMaximumSize(new Dimension(60, 23));
        this.jToggleButton2.setMinimumSize(new Dimension(60, 23));
        this.jToggleButton2.setPreferredSize(new Dimension(60, 23));
        this.jToggleButton2.putClientProperty("JButton.buttonType", "roundRect");
        this.jToggleButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Client.this.jToggleButton2ActionPerformed(evt);
            }
        });
        this.jLabel2.setText("COM Port");
        this.jComboBox1.setMaximumSize(new Dimension(73, 23));
        this.jComboBox1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                Client.this.jComboBox1ItemStateChanged(evt);
            }
        });
        this.jLabel3.setText("IP Adress");
        this.jTextField1.setText("192.168.4.1");
        this.jLabel4.setText("White LED Brightness");
        this.jLabel5.setText("UV LED Brightness");
        this.jSlider1.setMaximum(1023);
        this.jSlider1.setValue(0);
        this.jSlider1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                Client.this.jSlider1MouseReleased(evt);
            }
        });
        this.jSlider1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                Client.this.jSlider1KeyReleased(evt);
            }
        });
        this.jSlider2.setMaximum(1023);
        this.jSlider2.setValue(0);
        this.jSlider2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                Client.this.jSlider2MouseReleased(evt);
            }
        });
        this.jSlider2.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                Client.this.jSlider2KeyReleased(evt);
            }
        });
        this.jLabel6.setFont(new Font("Helvetica Neue", 0, 24));
        this.jLabel6.setForeground(new Color(102, 102, 102));
        this.jLabel6.setText("Connectivity");
        this.jLabel7.setFont(new Font("Helvetica Neue", 0, 24));
        this.jLabel7.setForeground(new Color(102, 102, 102));
        this.jLabel7.setText("Lighting");
        this.jLabel8.setFont(new Font("Helvetica Neue", 0, 24));
        this.jLabel8.setForeground(new Color(102, 102, 102));
        this.jLabel8.setText("Sensing");
        this.jButton1.setText("Retrive Value");
        this.jButton1.setMaximumSize(new Dimension(120, 23));
        this.jButton1.setMinimumSize(new Dimension(120, 23));
        this.jButton1.setPreferredSize(new Dimension(120, 23));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Client.this.jButton1ActionPerformed(evt);
            }
        });
        this.jLabel9.setText("Record Frequency");
        this.jComboBox2.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3", "4", "5"}));
        this.jLabel10.setText("Record Length");
        this.jLabel11.setText("Sec");
        this.jButton2.setText("Start Recording");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Client.this.jButton2ActionPerformed(evt);
            }
        });
        this.jLabel12.setText("Sensor Output Scaling");
        this.jComboBox3.setModel(new DefaultComboBoxModel<String>(new String[]{"2", "20", "100"}));
        this.jComboBox3.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                Client.this.jComboBox3ItemStateChanged(evt);
            }
        });
        this.jLabel13.setText("Hz");
        this.jLabel14.setText("%");
        this.jButton4.setText("Connect");
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Client.this.jButton4ActionPerformed(evt);
            }
        });
        this.icon.setIcon(new FlatSVGIcon("com/formdev/flatlaf/demo/extras/svg/actions/suspend.svg"));
        this.jSpinner1.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3)).addGap(173, 173, 173).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jToggleButton1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jToggleButton2, -2, -1, -2)).addComponent(this.jComboBox1, -2, 132, -2).addComponent(this.jTextField1))).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.icon, -2, 29, -2)).addComponent(this.jSeparator1).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSlider1, -2, -1, -2).addComponent(this.jSlider2, GroupLayout.Alignment.TRAILING, -2, -1, -2))).addComponent(this.jSeparator2).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton1, -2, 118, -2)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel9).addComponent(this.jLabel10)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButton2, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jComboBox2, 0, 92, Short.MAX_VALUE).addComponent(this.jSpinner1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel11).addComponent(this.jLabel13, GroupLayout.Alignment.TRAILING))))).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel12).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jComboBox3, -2, 92, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel14)).addComponent(this.jButton4, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator3, GroupLayout.Alignment.TRAILING, -2, 261, -2).addComponent(this.jSeparator4, GroupLayout.Alignment.TRAILING, -2, 261, -2)))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel6, -1, -1, Short.MAX_VALUE).addComponent(this.icon, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jToggleButton1).addComponent(this.jToggleButton2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jComboBox1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextField1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 9, -2).addGap(2, 2, 2).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jSlider1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel5).addComponent(this.jSlider2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator2, -2, 9, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.jButton1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator3, -2, 9, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.jComboBox2, -2, -1, -2).addComponent(this.jLabel13)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel11).addComponent(this.jSpinner1, -2, -1, -2).addComponent(this.jLabel10)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator4, -2, 3, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel12).addComponent(this.jComboBox3, -2, -1, -2).addComponent(this.jLabel14)).addContainerGap()));
        this.jSplitPane1.setLeftComponent(this.jPanel1);
        this.jLabel15.setFont(new Font("Helvetica Neue", 0, 24));
        this.jLabel15.setForeground(new Color(102, 102, 102));
        this.jLabel15.setText("Data");
        this.jTable2.setModel(new DefaultTableModel(new Object[0][], new String[]{"Time", "Red", "Grenn", "Blue", "White Brightness", "UV Brightness"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class};
                this.canEdit = new boolean[]{false, false, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTable2.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane2.setViewportView(this.jTable2);
        this.jButton3.setText("Export");
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Client.this.jButton3ActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel15).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton3).addContainerGap()).addComponent(this.jScrollPane2, -1, 398, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel15).addComponent(this.jButton3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 428, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane1.setRightComponent(this.jPanel2);
        this.jMenu1.setText("File");
        this.jMenuItem1.setAccelerator(KeyStroke.getKeyStroke(69, 192));
        this.jMenuItem1.setText("Export Data");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Client.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem1);
        this.jMenu1.add(this.jSeparator5);
        this.jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(65, 192));
        this.jMenuItem3.setText("About");
        this.jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Client.this.jMenuItem3ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem3);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu2.setText("Edit");
        this.jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(88, 640));
        this.jMenuItem2.setText("Clear Data Table");
        this.jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Client.this.jMenuItem2ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem2);
        this.jMenuBar1.add(this.jMenu2);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1));
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void jToggleButton1ActionPerformed(ActionEvent evt) {
        this.proc = this.comProc;
        this.comPorts = SerialPort.getCommPorts();
        List<String> content = this.com.getPortNames();
        this.serialMode = true;
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>((String[])content.toArray(String[]::new)));
        this.jTextField1.setEnabled(false);
        this.jLabel3.setEnabled(false);
        this.jLabel2.setEnabled(true);
        this.jComboBox1.setEnabled(true);
    }

    private void jComboBox1ItemStateChanged(ItemEvent evt) {
        this.com.setCom(SerialPort.getCommPort((String)this.jComboBox1.getSelectedItem()));
    }

    private void jToggleButton2ActionPerformed(ActionEvent evt) {
        this.proc = this.httpProc;
        this.jTextField1.setEnabled(true);
        this.jLabel3.setEnabled(true);
        this.jLabel2.setEnabled(false);
        this.jComboBox1.setEnabled(false);
        this.serialMode = false;
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        if (this.serialMode) {
            try {
                this.com.initSerialPort();
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            boolean connected = this.connectCOM();
            if (connected) {
                this.icon.setIcon(new FlatSVGIcon("com/formdev/flatlaf/demo/extras/svg/actions/execute.svg"));
                JOptionPane.showMessageDialog(this, "Connected Successfully!");
                this.enableFunc(true);
            } else {
                JOptionPane.showMessageDialog(this, "Connection Failed!");
                this.enableFunc(false);
                this.icon.setIcon(new FlatSVGIcon("com/formdev/flatlaf/demo/extras/svg/actions/suspend.svg"));
            }
        } else {
            boolean connected = this.connectHTTP();
            if (connected) {
                this.icon.setIcon(new FlatSVGIcon("com/formdev/flatlaf/demo/extras/svg/actions/execute.svg"));
                JOptionPane.showMessageDialog(this, "Connected Successfully!");
                this.enableFunc(true);
            } else {
                JOptionPane.showMessageDialog(this, "Connection Failed!");
                this.enableFunc(false);
                this.icon.setIcon(new FlatSVGIcon("com/formdev/flatlaf/demo/extras/svg/actions/suspend.svg"));
            }
        }
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(0);
        fileChooser.setFileFilter(new FileNameExtensionFilter("Comma-Separated Values Spreadsheet (.CSV)", "csv"));
        int returnVal = fileChooser.showSaveDialog(this);
        if (returnVal == 0) {
            File fileName = new File(fileChooser.getSelectedFile().getAbsolutePath());
            if (!fileName.getName().contains(".csv")) {
                fileName = new File(fileName.getParentFile(), fileName.getName() + ".csv");
            }
            try {
                FileOutputStream outputStream = new FileOutputStream(fileName);
                Object content = "Time,Red,Green,Blue,White Brightness,UV Brightness\n";
                for (int row = 0; row < this.jTable2.getRowCount(); ++row) {
                    CharSequence[] rowContent = new String[6];
                    for (int col = 0; col < 6; ++col) {
                        rowContent[col] = "" + this.jTable2.getValueAt(row, col);
                    }
                    content = (String)content + String.join((CharSequence)",", rowContent) + "\n";
                }
                outputStream.write(((String)content).getBytes());
                outputStream.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void jSlider1MouseReleased(MouseEvent evt) {
        this.proc.setWhite(this.jSlider1.getValue());
    }

    private void jSlider2MouseReleased(MouseEvent evt) {
        this.proc.setUV(this.jSlider2.getValue());
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        Record rec = this.proc.getRGB();
        if (rec != null) {
            this.addRecord(rec);
        }
    }

    private void jComboBox3ItemStateChanged(ItemEvent evt) {
        this.proc.setScal(Integer.parseInt((String)this.jComboBox3.getSelectedItem()));
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        this.jButton3ActionPerformed(evt);
    }

    private void jMenuItem2ActionPerformed(ActionEvent evt) {
        DefaultTableModel model = (DefaultTableModel)this.jTable2.getModel();
        model.setRowCount(0);
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        if (this.periCoder != null) {
            this.periCoder.stop();
        }
        this.periCoder = new PeriodicRecorder(this.proc, Integer.parseInt((String)this.jComboBox2.getSelectedItem()), (Integer)this.jSpinner1.getValue(), this);
        this.periCoder.start();
    }

    private void jMenuItem3ActionPerformed(ActionEvent evt) {
        new About().setVisible(true);
    }

    private void jSlider1KeyReleased(KeyEvent evt) {
        this.proc.setWhite(this.jSlider1.getValue());
    }

    private void jSlider2KeyReleased(KeyEvent evt) {
        this.proc.setUV(this.jSlider2.getValue());
    }

    private boolean connectCOM() {
        return this.comProc.testConnect();
    }

    private boolean connectHTTP() {
        this.httpProc.setIpAdr(this.jTextField1.getText());
        return this.httpProc.testConnect();
    }

    public void addRecord(Record rec) {
        DefaultTableModel model = (DefaultTableModel)this.jTable2.getModel();
        model.addRow(new Object[]{rec.getDatetime(), rec.getR(), rec.getG(), rec.getB(), this.jSlider1.getValue(), this.jSlider2.getValue()});
        this.jTable2.scrollRectToVisible(this.jTable2.getCellRect(this.jTable2.getRowCount() - 1, 0, true));
    }

    private void enableFunc(boolean enabled) {
        this.jLabel4.setEnabled(enabled);
        this.jLabel5.setEnabled(enabled);
        this.jLabel9.setEnabled(enabled);
        this.jLabel10.setEnabled(enabled);
        this.jLabel11.setEnabled(enabled);
        this.jLabel12.setEnabled(enabled);
        this.jLabel13.setEnabled(enabled);
        this.jLabel14.setEnabled(enabled);
        this.jSlider1.setEnabled(enabled);
        this.jSlider2.setEnabled(enabled);
        this.jButton1.setEnabled(enabled);
        this.jButton2.setEnabled(enabled);
        this.jComboBox2.setEnabled(enabled);
        this.jComboBox3.setEnabled(enabled);
        this.jSpinner1.setEnabled(enabled);
    }

    public static void main(String[] args) {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "Sensor Board Client");
        try {
            UIManager.setLookAndFeel(new FlatDarkLaf());
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(Client.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Client().setVisible(true);
            }
        });
    }
}

